import pandas as pd  
import scipy.stats as stats  
import pickle 
from decision_company import read_csv_file, logical_and

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Create a new column to identify younger customers (aged 18-35)  
age_column = credit_customers['age'] 
credit_customers['young_customer'] = logical_and(age_column >= 18, age_column <= 35)  

print("credit_young_customer")
print(credit_customers['young_customer'])  
pickle.dump(credit_customers['young_customer'],open("./ref_result/credit_young_customer.pkl","wb"))